	function [EE] = bpmf_get_ee(Z,NIN,NZ,Amax,q)
	%  
	% Returns the E*conj(E) given an attenuation pole 
	% vector Z, the number of attenuation poles  
	% at infinity NIN, the number of attenuation poles 
	% at the origin NZ, the passband attenuation Amax
	% and the passband quotient q = wb/wa.
	
	% Author: 			Per Loewenborg
    % Modified by:		LW 
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	larsw@isy.liu.se
	
	m = NZ+NIN+2*length(Z);
	A_sq = ( (q^(2*NZ))*prod(Z.^4) )^(1/m);
	ep_sqred = (10^(0.1*Amax))-1;
	
	% Find F^2 and Q^2
	N = length(Z);
	if N > 0
		Q2 = [1 0 -2*(Z(1)^2) 0 Z(1)^4];
		for k = 2:N
			Q2 = conv(Q2,[1 0 -2*(Z(k)^2) 0 Z(k)^4]);
		end
		if NIN > 0
			for k = 1:NIN
				Q2 = conv(Q2,[1 0 -1]);
			end    
		end
		if NZ > 0
			for k = 1:NZ
				Q2 = conv(Q2,[1 0 -(q^2)]);
			end
		end
		Q2 = Q2*((-1)^(NIN + NZ));
	else % No attenuation poles  
		Q2 = [1];
		if NIN > 0
			for k = 1:NIN
				Q2 = conv(Q2,[1 0 -1]);
			end    
		end
		if NZ > 0
			for k = 1:NZ
				Q2 = conv(Q2,[1 0 -(q^2)]);
			end
		end   
		Q2 = Q2*((-1)^(NIN + NZ));
	end
	F2 = [1];	
	for k = 1:m		
		F2 = conv(F2,[1 0 A_sq]);   
	end	
	F2 = F2*ep_sqred;	
	dif = length(Q2) - length(F2);
	if dif > 0
		z = zeros(1,dif);
		F2 = [z F2];
	else
		z = zeros(1,dif);
		Q2 = [z Q2];
	end
	EE = F2+Q2;
